#pragma once

#include "Service.h"
#include "ConfigNWK.h"
/////////////////////////////////////////////////////////////////////////////

#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
/////////////////////////////////////////////////////////////////////////////

class DLLMANAGER_API CServiceNWK : public CService
{
public:
	CServiceNWK(void);
	CServiceNWK(CDllManager* iDllManager);
	virtual ~CServiceNWK(void);
	//Common API
	virtual Bool Dispatch(CCmd* iCmdP);
	virtual void OnConfigChange(int configID);
	virtual void OnConfigChange(int configID, int iConfigEvent);

	//ATCommand Function
	Bool COPN(CCmd* iCmdP, Bool iSilentMode=0); 
	Bool CSQ(CCmd* iCmdP, Bool iSilentMode=0);
	Bool COPS(CCmd* iCmdP, Bool iSilentMode=0);
	Bool CREG(CCmd* iCmdP, Bool iSilentMode=0);
	virtual void CREGGetLocalInfo(CCmd* iCmdP, Bool iSilentMode);
	Bool CPOL(CCmd* iCmdP, Bool iSilentMode=0);

protected:
	UInt32 GetNetworkId(networksType iNet);
	Bool PrvGetNetworkType(int iFormat, CString iOper, CNwkDesc* ioNwkDesc);
	
	Bool PrvCOPSSet(CCmd* iCmdP, Bool iSilentMode);
	Bool PrvCOPSList(CCmd* iCmdP, Bool iSilentMode);
	Bool PrvCOPSGet(CCmd* iCmdP, Bool iSilentMode);
	Bool PrvCOPSSetAuto(CCmd* iCmdP, Bool iSilentMode);
	Bool PrvCOPSSetManual(CCmd* iCmdP, Bool iSilentMode);
	Bool PrvCOPSSetUnregister(CCmd* iCmdP, Bool iSilentMode);
	POSITION PrvGetPreferredNwk(int iIndex, CList<CNwkDesc, CNwkDesc&>* iPreferredNwkDesc);
	Bool PrvCPOLSet(CCmd* iCmdP, Bool iSilentMode);	
};
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////